<?php
require '../function/conn.php';
require '../function/function.php';
require '../function/mobile.php';

function decrypt($ciphertext, $iv, $app_key, $session_key) {
    $session_key = base64_decode($session_key);
    $iv = base64_decode($iv);
    $ciphertext = base64_decode($ciphertext);

    $plaintext = false;
    if (function_exists("openssl_decrypt")) {
        $plaintext = openssl_decrypt($ciphertext, "AES-192-CBC", $session_key, OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING, $iv);
    } else {
        $td = mcrypt_module_open(MCRYPT_RIJNDAEL_128, null, MCRYPT_MODE_CBC, null);
        mcrypt_generic_init($td, $session_key, $iv);
        $plaintext = mdecrypt_generic($td, $ciphertext);
        mcrypt_generic_deinit($td);
        mcrypt_module_close($td);
    }
    if ($plaintext == false) {
        return false;
    }

    // trim pkcs#7 padding
    $pad = ord(substr($plaintext, -1));
    $pad = ($pad < 1 || $pad > 32) ? 0 : $pad;
    $plaintext = substr($plaintext, 0, strlen($plaintext) - $pad);

    // trim header
    $plaintext = substr($plaintext, 16);
    // get content length
    $unpack = unpack("Nlen/", substr($plaintext, 0, 4));
    // get content
    $content = substr($plaintext, 4, $unpack['len']);
    // get app_key
    $app_key_decode = substr($plaintext, $unpack['len'] + 4);

    return $app_key == $app_key_decode ? $content : false;
}

class ErrorCode
{
    public static $OK = 0;
    public static $IllegalAesKey = -41001;
    public static $IllegalIv = -41002;
    public static $IllegalBuffer = -41003;
    public static $DecodeBase64Error = -41004;
}


class WXBizDataCrypt
{
    private $appid;
    private $sessionKey;

    public function __construct( $appid, $sessionKey)
    {
        $this->sessionKey = $sessionKey;
        $this->appid = $appid;
    }

    public function decryptData( $encryptedData, $iv, &$data )
    {
        if (strlen($this->sessionKey) != 24) {
            return ErrorCode::$IllegalAesKey;
        }
        $aesKey=base64_decode($this->sessionKey);

        
        if (strlen($iv) != 24) {
            return ErrorCode::$IllegalIv;
        }
        $aesIV=base64_decode($iv);

        $aesCipher=base64_decode($encryptedData);

        $result=openssl_decrypt( $aesCipher, "AES-128-CBC", $aesKey, 1, $aesIV);

        $dataObj=json_decode( $result );
        if( $dataObj  == NULL )
        {
            return ErrorCode::$IllegalBuffer;
        }
        if( $dataObj->watermark->appid != $this->appid )
        {
            return ErrorCode::$IllegalBuffer;
        }
        $data = $result;
        return ErrorCode::$OK;
    }

}

if ($_REQUEST["action"] == "") {
    die();
}
if (!check_auth2("wxapp")) {
    echo "{\"code\":\"error\",\"code_info\":\"尚未开通小程序功能\"}";
    die();
}
$action = $_REQUEST["action"];
$id = $_REQUEST["id"];
$S_id = $_REQUEST["id"];
$U_id = $_REQUEST["U_id"];
$page = $_REQUEST["page"];
$num = $_REQUEST["num"];
$order = $_REQUEST["order"];
$typex = $_REQUEST["type"];
$keyword = $_REQUEST["keyword"];
$callback = $_REQUEST["callback"];
$M_login = $_REQUEST["M_login"];
$M_pwd = $_REQUEST["M_pwd"];
$M_id = intval($_REQUEST["M_id"]);
$page = $_REQUEST["page"];
switch ($action) {
    case "getuid":
        $sql = "select * from ".TABLE."menu where U_del=0 and U_type='" . $typex . "' and U_typeid=" . $id;
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if (mysqli_num_rows($result) > 0) {
            $U_id = $row["U_id"];
        }
        $api = "{\"U_id\":\"" . $U_id . "\"}";
        break;

    case "left":
        if ($U_id == "") {
            die();
        }
        $sql = "select * from ".TABLE."menu where U_id=" . $U_id;
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if (mysqli_num_rows($result) > 0) {
            $U_sub = $row["U_sub"];
        } else {
            $left_list = "";
            die();
        }
        if ($U_sub != 0) {
            $sql = "select * from ".TABLE."menu where U_del=0 and U_sub=" . $U_sub . " and not U_sub=0 and U_hide=0 order by U_order";
            $result = mysqli_query($conn, $sql);
            if (mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    $leftlist = $leftlist . "{\"L_id\":" . $row["U_id"] . ",\"L_type\":\"" . $row["U_type"] . "\",\"L_typeID\":\"" . $row["U_typeid"] . "\",\"L_title\":\"" . lang($row["U_title"]) . "\"},";
                }
            }
        } else {
            $sql = "select * from ".TABLE."menu where U_del=0 and U_sub=" . $U_id . " and not U_sub=0 and U_hide=0 order by U_order";
            $result = mysqli_query($conn, $sql);
            if (mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    $leftlist = $leftlist . "{\"L_id\":" . $row["U_id"] . ",\"L_type\":\"" . $row["U_type"] . "\",\"L_typeID\":\"" . $row["U_typeid"] . "\",\"L_title\":\"" . lang($row["U_title"]) . "\"},";
                }
            }
        }
        $leftlist = substr($leftlist, 0, strlen($leftlist) - 1);
        $api = "{\"leftlist\":[" . $leftlist . "]}";
        break;

    case "config":
        $sql = "select * from ".TABLE."menu where U_del=0 and U_sub=0 order by U_order";
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $sql1 = "select * from ".TABLE."menu where U_del=0 and U_sub=" . $row["U_id"] . " order by U_order";
                $result1 = mysqli_query($conn, $sql1);
                if (mysqli_num_rows($result1) > 0) {
                    while ($row1 = mysqli_fetch_assoc($result1)) {
                        $submenu = $submenu . "{\"U_id\":" . $row1["U_id"] . ",\"U_order\":" . $row1["U_order"] . ",\"U_type\":\"" . $row1["U_type"] . "\",\"U_typeid\":" . $row1["U_typeid"] . ",\"U_title\":\"" . gljson(lang($row1["U_title"])) . "\",\"U_entitle\":\"" . gljson(lang($row1["U_entitle"])) . "\",\"U_ico\":\"" . gljson($row1["U_ico"]) . "\",\"U_color\":\"" . $row1["U_color"] . "\",\"U_url\":\"" . gljson($row1["U_url"]) . "\",\"U_hide\":\"" . $row1["U_hide"] . "\"},";
                    }
                    $submenu = substr($submenu, 0, strlen($submenu) - 1);
                }
                $menu = $menu . "{\"U_id\":" . $row["U_id"] . ",\"U_order\":" . $row["U_order"] . ",\"U_type\":\"" . $row["U_type"] . "\",\"U_typeid\":" . $row["U_typeid"] . ",\"U_title\":\"" . gljson(lang($row["U_title"])) . "\",\"U_entitle\":\"" . gljson(lang($row["U_entitle"])) . "\",\"U_ico\":\"" . gljson($row["U_ico"]) . "\",\"U_color\":\"" . $row["U_color"] . "\",\"U_url\":\"" . gljson($row["U_url"]) . "\",\"U_hide\":\"" . $row["U_hide"] . "\",\"sub_menu\":[" . $submenu . "]},";
                $submenu = " ";
            }
            $menu = substr($menu, 0, strlen($menu) - 1);
        }
        $tab = explode(",", $C_wxapptabbar);
        for ($i = 0; $i < count($tab); $i++) {
            if (is_numeric($tab[$i])) {
                $tabs = $tabs . "{\"U_title\":\"" . lang(getrx("select * from ".TABLE."menu where U_id=" . $tab[$i],"U_title")) . "\",\"U_ico\":\"" . gljson(getrx("select * from ".TABLE."menu where U_id=" . $tab[$i],"U_ico")) . "\",\"U_url\":\"../" . getrx("select * from ".TABLE."menu where U_id=" . $tab[$i],"U_type") . "/" . getrx("select * from ".TABLE."menu where U_id=" . $tab[$i],"U_type") . "?id=" . getrx("select * from ".TABLE."menu where U_id=" . $tab[$i],"U_typeid") . "\",\"U_type\":\"" . getrx("select * from ".TABLE."menu where U_id=" . $tab[$i],"U_type") . "\",\"U_typeid\":\"" . getrx("select * from ".TABLE."menu where U_id=" . $tab[$i],"U_typeid") . "\"},";
            } else {
                switch ($tab[$i]) {
                    case "m":
                        $tabs = $tabs . "{\"U_title\":\"会员中心\",\"U_ico\":\"user\",\"U_url\":\"../member/member\",\"U_type\":\"member\"},";
                        break;

                    case "s":
                        $tabs = $tabs . "{\"U_title\":\"搜索内容\",\"U_ico\":\"search\",\"U_url\":\"../search/search\",\"U_type\":\"search\"},";
                        break;

                    case "c":
                        $tabs = $tabs . "{\"U_title\":\"购物车\",\"U_ico\":\"shopping-cart\",\"U_url\":\"../cart/cart\",\"U_type\":\"cart\"},";
                }
            }
        }
        $tabs = substr($tabs, 0, strlen($tabs) - 1);
        $config = "{\"C_webtitle\":\"" . gljson(lang($C_wxapptitle)) . "\",\"C_wxapptitle\":\"" . gljson(lang($C_wxapptitle)) . "\",\"C_domain\":\"" . $_SERVER["HTTP_HOST"] . "\",\"C_description\":\"" . gljson(lang($C_description)) . "\",\"C_logo\":\"http://" . $C_domain . $C_dir . $C_logo . "\",\"C_wxapplogo\":\"http://" . $C_domain . $C_dir . $C_wxapplogo . "\",\"C_foot\":\"" . gljson(lang($C_foot)) . "\",\"C_psorttitle\":\"" . gljson(lang($C_psorttitle)) . "\",\"C_nsorttitle\":\"" . gljson(lang($C_nsorttitle)) . "\",\"W_phone\":\"" . $W_phone . "\",\"C_shoukuan\":\"".gljson($C_shoukuan)."\"}";
        $api = "{\"main_menu\":[" . $menu . "],\"tabbar\":[" . $tabs . "],\"config\":" . $config . "}";
        break;

    case "text_list":
        $sql = "select * from ".TABLE."text where T_del=0 order by T_order,T_id desc";
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $textlist = $textlist . "{\"T_id\":\"" . $row["T_id"] . "\",\"T_title\":\"" . lang($row["T_title"]) . "\",\"T_entitle\":\"" . lang($row["T_entitle"]) . "\",\"T_pic\":\"//" . $C_domain . $C_dir . $row["T_pic"] . "\",\"T_order\":\"" . $row["T_order"] . "\"},";
            }
            $textlist = substr($textlist, 0, strlen($textlist) - 1);
        }
        $api = "{\"text_list\":[" . $textlist . "]}";
        break;

    case "text_info":
        if ($id == "") {
            $id = "a";
        }
        if (is_numeric($id)) {
            $sql = "select * from ".TABLE."text where T_del=0 and T_id=" . $id;
        } else {
            switch ($id) {
                case "a":
                    $top = 0;
                    break;

                case "b":
                    $top = 1;
                    break;

                case "c":
                    $top = 2;
                    break;

                case "d":
                    $top = 3;
                    break;

                case "e":
                    $top = 4;
                    break;

                case "f":
                    $top = 5;
                    break;

                case "g":
                    $top = 6;
                    break;

                case "h":
                    $top = 7;
                    break;

                case "i":
                    $top = 8;
                    break;

                case "j":
                    $top = 9;
                    break;

                case "k":
                    $top = 10;
            }
            if ($top == 0) {
                $sql = "select * from ".TABLE."text where T_del=0 order by T_order,T_id desc limit 1";
            } else {
                $sql = "select * from (SELECT  * FROM ".TABLE."text where T_del=0 order by T_order,T_id desc limit " . ($top + 1) . ")a order by T_order desc,T_id asc limit 1";
            }
        }
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if (mysqli_num_rows($result) > 0) {
            $T_title = $row["T_title"];
            $T_entitle = $row["T_entitle"];
            $T_pagetitle = $row["T_pagetitle"];
            $T_keywords = $row["T_keywords"];
            $T_description = $row["T_description"];
            $T_pic = $row["T_pic"];
            $T_link = $row["T_link"];
            $T_content = str_Replace("{@SL_安装目录}", "http://" . $C_domain . $C_dir, lang($row["T_content"]));
            $T_content = str_Replace("class","alt",$T_content);
        }
        $api = "{\"T_id\":\"" . $id . "\",\"T_title\":\"" . gljson(lang($T_title)) . "\",\"T_entitle\":\"" . gljson(lang($T_entitle)) . "\",\"T_pagetitle\":\"" . gljson(lang($T_pagetitle)) . "\",\"T_keywords\":\"" . gljson(lang($T_keywords)) . "\",\"T_description\":\"" . gljson(lang($T_description)) . "\",\"T_pic\":\"http://" . $C_domain . $C_dir . $T_pic . "\",\"T_link\":\"" . $T_link . "\",\"T_content\":\"" . gljson($T_content) . "\"}";
        break;

    case "text_intro":
        if ($num == "") {
            $num = 100;
        }
        if (is_numeric($id)) {
            $sql = "select * from ".TABLE."text where T_del=0 and T_id=" . $id;
        } else {
            switch ($id) {
                case "a":
                    $top = 0;
                    break;

                case "b":
                    $top = 1;
                    break;

                case "c":
                    $top = 2;
                    break;

                case "d":
                    $top = 3;
                    break;

                case "e":
                    $top = 4;
                    break;

                case "f":
                    $top = 5;
                    break;

                case "g":
                    $top = 6;
                    break;

                case "h":
                    $top = 7;
                    break;

                case "i":
                    $top = 8;
                    break;

                case "j":
                    $top = 9;
                    break;

                case "k":
                    $top = 10;
            }
            if ($top == 0) {
                $sql = "select * from ".TABLE."text where T_del=0 order by T_order,T_id desc limit 1";
            } else {
                $sql = "select * from (select * from ".TABLE."text where T_del=0 order by T_order,T_id desc limit " . ($top + 1) . ")a order by T_order desc,T_id asc limit 1";
            }
        }
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $T_id = $row["T_id"];
                $T_title = $row["T_title"];
                $T_entitle = $row["T_entitle"];
                $T_pagetitle = $row["T_pagetitle"];
                $T_keywords = $row["T_keywords"];
                $T_description = $row["T_description"];
                $T_pic = $row["T_pic"];
                $T_link = $row["T_link"];
                $T_content = str_Replace("{@SL_安装目录}", "http://" . $C_domain . $C_dir, lang($row["T_content"]));
                $T_content = str_Replace("class","alt",$T_content);
                $api = "{\"T_id\":\"" . $T_id . "\",\"T_title\":\"" . gljson(lang($T_title)) . "\",\"T_entitle\":\"" . gljson(lang($T_entitle)) . "\",\"T_pagetitle\":\"" . gljson(lang($T_pagetitle)) . "\",\"T_keywords\":\"" . gljson(lang($T_keywords)) . "\",\"T_description\":\"" . gljson(lang($T_description)) . "\",\"T_pic\":\"http://" . $C_domain . $C_dir . $T_pic . "\",\"T_link\":\"" . $T_link . "\",\"T_content\":\"" . gljson(mb_substr(strip_tags($T_content) , 0, $num,"utf-8")) . "\"}";
            }
        }
        break;

    case "news_info":
        if ($id != "") {
            mysqli_query($conn, "update ".TABLE."news set N_view=$N_view+1 where N_id=" . $id);
            $sql = "select * from ".TABLE."news where N_del=0 and N_id=" . $id;
            $result = mysqli_query($conn, $sql);
            $row = mysqli_fetch_assoc($result);
            if (mysqli_num_rows($result) > 0) {
                $N_title = lang($row["N_title"]);
                $N_author = $row["N_author"];
                $N_view = $row["N_view"];
                $N_content = str_Replace("{@SL_安装目录}", "http://" . $C_domain . $C_dir, lang($row["N_content"]));
                $N_content = str_Replace("class","alt",$N_content);
                $N_pic = $row["N_pic"];
                $N_link = $row["N_link"];
                $N_sort = $row["N_sort"];
                $N_date = $row["N_date"];
                $N_top = $row["N_top"];
                $N_sh = $row["N_sh"];
                $N_type = $row["N_type"];
                $N_file = $row["N_file"] . "|||||||||";
                $N_job = $row["N_job"] . "|||||||||";
                $jobname=explode("@",$row["N_jobname"]);

                if(substr($row["N_video"],0,4)=="http"){
                    $N_video = $row["N_video"];
                }else{
                    $N_video = "http://" . $C_domain . $C_dir.$row["N_video"];
                }

                $N_lv = $row["N_lv"];
                $N_tag = $row["N_tag"];
                $N_price = $row["N_price"];
                $N_hide = $row["N_hide"];
                $N_hideon = $row["N_hideon"];
                $N_hidetype = $row["N_hidetype"];
                $N_hideintro = $row["N_hideintro"];
                $N_color = $row["N_color"];
                $N_strong = $row["N_strong"];
                $N_pagetitle = lang($row["N_pagetitle"]);
                $N_keywords = lang($row["N_keywords"]);
                $N_description = lang($row["N_description"]);
                if ($N_job == "" || is_null($N_job)) {
                    $N_job = "|||||||||||";
                }
                if ($N_file == "" || is_null($N_file)) {
                    $N_file = "|||||||||";
                }
            }
        } else {
            $N_date = date('Y-m-d H:i:s');
            $N_author = $_COOKIE["user"];
            $N_job = "|||||||||||";
            $N_file = "|||||||||";
            $N_pic = "images/nopic.png";
            $N_hidetype = "div";
            $N_view = 100;
        }
        $job = explode("|", $N_job);
        $file = explode("|", $N_file);

	    if(lang($jobname[0])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[0])."：</b>".$job[0]."</p>";
	    }
	    if(lang($jobname[1])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[1])."：</b>".$job[1]."</p>";
	    }
	    if(lang($jobname[2])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[2])."：</b>".$job[2]."</p>";
	    }
	    if(lang($jobname[3])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[3])."：</b>".$job[3]."</p>";
	    }
	    if(lang($jobname[4])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[4])."：</b>".$job[4]."</p>";
	    }
	    if(lang($jobname[5])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[5])."：</b>".$job[5]."</p>";
	    }
	    if(lang($jobname[6])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[6])."：</b>".$job[6]."</p>";
	    }
	    if(lang($jobname[7])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[7])."：</b>".$job[7]."</p>";
	    }
	    if(lang($jobname[8])!=""){
	        $job_info=$job_info."<p><b>".lang($jobname[8])."：</b>".$job[8]."</p>";
	    }

        $file_info = "<table><tr><td><b>文件名称</b><br>" . $file[0] . "</td><td><b>文件大小</b><br>" . $file[1] . "</td><td><b>版本号</b><br>" . $file[2] . "</td></tr><tr><td><b>语言</b><br>" . $file[3] . "</td><td><b>运行环境</b><br>" . $file[4] . "</td><td><b>下载地址</b><br><a class=\"download\" href=\"" . $C_dir . "js/scms.asp?action=download.N_id=" . $N_idx . "\" target=\"_blank\">点击下载</a></td></tr></table>";
        if (strpos($N_video, "<") !== false) {
            $video_info = $N_video;
        } else {
            if (substr($N_video, 0, 5) == "media") {
                $video_info = "<video width=\"100%\" height=\"500\" controls><source src=\"" . $C_dir . $N_video . "\" type=\"video/mp4\">您的浏览器不支持 video 标签。</video>";
            } else {
                $video_info = "<video width=\"100%\" height=\"500\" controls><source src=\"" . $N_video . "\" type=\"video/mp4\">您的浏览器不支持 video 标签。</video>";
            }
        }
        switch ($N_type) {
            case 0:
                $HTMLCode = "";
                break;

            case 1:
                $HTMLCode = $job_info;
                break;

            case 2:
                $HTMLCode = $file_info;
                break;

            case 3:
                //$HTMLCode = $video_info;
        }
        $api = "{\"N_title\":\"" . gljson($N_title) . "\",\"N_author\":\"" . $N_author . "\",\"N_view\":\"" . $N_view . "\",\"N_content\":\"" . gljson($N_content) . "\",\"N_date\":\"" . $N_date . "\",\"N_pagetitle\":\"" . gljson($N_pagetitle) . "\",\"N_keywords\":\"" . gljson($N_keywords) . "\",\"N_description\":\"" . gljson($N_description) . "\",\"N_pic\":\"http://" . $C_domain . $C_dir . $N_pic . "\",\"N_link\":\"" . $N_link . "\",\"N_sort\":\"" . $N_sort . "\",\"N_top\":\"" . $N_top . "\",\"N_sh\":\"" . $N_sh . "\",\"N_type\":\"" . $N_type . "\",\"N_lv\":\"" . $N_lv . "\",\"N_color\":\"" . gljson($N_color) . "\",\"N_strong\":\"" . $N_strong . "\",\"N_video\":\"" . gljson($N_video) . "\",\"N_job1\":\"" . $job[0] . "\",\"N_job2\":\"" . $job[1] . "\",\"N_job3\":\"" . $job[2] . "\",\"N_job4\":\"" . $job[3] . "\",\"N_job5\":\"" . $job[4] . "\",\"N_job6\":\"" . $job[5] . "\",\"N_job7\":\"" . $job[6] . "\",\"N_job8\":\"" . $job[7] . "\",\"N_job9\":\"" . $job[8] . "\",\"N_file1\":\"" . $file[0] . "\",\"N_file2\":\"" . $file[1] . "\",\"N_file3\":\"" . $file[2] . "\",\"N_file4\":\"" . $file[3] . "\",\"N_file5\":\"" . $file[4] . "\",\"N_file6\":\"" . $file[5] . "\",\"N_file7\":\"" . $file[6] . "\",\"N_hide\":\"" . gljson($N_hide) . "\",\"N_hideon\":\"" . $N_hideon . "\",\"N_price\":\"" . $N_price . "\",\"N_hidetype\":\"" . $N_hidetype . "\",\"N_hideintro\":\"" . gljson($N_hideintro) . "\",\"N_other\":\"" . gljson($HTMLCode) . "\"}";
        break;


   case "notice":
    $sql="select * from ".TABLE."news where N_type=4 and N_del=0";
	$result = mysqli_query($conn, $sql);
	$arr = array();  
	while($row = mysqli_fetch_array($result)) {
		$count=count($row);
		  for($i=0;$i<$count;$i++){ 
		    unset($row[$i]);
		  }   
	    array_push($arr,$row);
	} 

	$api=json_encode($arr);
    break;

    case "product_list";
    if (strpos($num, "|") !== false) {
        $num = $C_ppage;
        $idx = "index";
    } else {
        $num = splitx($num, "|", 0);
        $idx = "";
    }
    $S_page = $page;
    if ($S_page == "") {
        $S_page = 1;
    }
    if ($S_id != 0) {
        $S_type = getrx("select * from ".TABLE."psort where S_id=" . $S_id,"S_type");
    } else {
        if (strpos($S_id, "|") !== false) {
            $S_type = splitx($S_id, "|", 1);
        } else {
            $S_type = 0;
        }
        if ($S_type == "") {
            $S_type = 0;
        }
    }
    $S_id = splitx($S_id, "|", 0);
    $S_iid = $S_id;
    if ($num == 0) {
        $num_info = "";
    } else {
        $num_info = "limit " . $num;
    }
    if (!is_numeric($S_id)) {
        $sql = "select * from ".TABLE."psort where S_del=0 and S_sub=0 order by S_order,S_id desc";
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $S_sublist = $S_sublist . $row["S_id"] . ",";
                $sql2 = "select * from ".TABLE."psort where S_del=0 and S_sub=" . $row["S_id"] . " order by S_order,S_id desc";
                $result2 = mysqli_query($conn, $sql2);
                if (mysqli_num_rows($result2) > 0) {
                    while ($row2 = mysqli_fetch_assoc($result2)) {
                        $S_list = $S_list . $row2["S_id"] . ",";
                    }
                }
            }
        }
        $S_list = $S_list . "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
        $S_sublist = $S_sublist . "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
        switch ($S_id) {
            case "a":
                $top = 0;
                $sub_info = 0;
                break;

            case "b":
                $top = 1;
                $sub_info = 0;
                break;

            case "c":
                $top = 2;
                $sub_info = 0;
                break;

            case "d":
                $top = 3;
                $sub_info = 0;
                break;

            case "e":
                $top = 4;
                $sub_info = 0;
                break;

            case "f":
                $top = 5;
                $sub_info = 0;
                break;

            case "g":
                $top = 6;
                $sub_info = 0;
                break;

            case "h":
                $top = 7;
                $sub_info = 0;
                break;

            case "i":
                $top = 8;
                $sub_info = 0;
                break;

            case "j":
                $top = 9;
                $sub_info = 0;
                break;

            case "k":
                $top = 10;
                $sub_info = 0;
                break;

            case "A":
                $top = 0;
                $sub_info = 1;
                break;

            case "B":
                $top = 1;
                $sub_info = 1;
                break;

            case "C":
                $top = 2;
                $sub_info = 1;
                break;

            case "D":
                $top = 3;
                $sub_info = 1;
                break;

            case "E":
                $top = 4;
                $sub_info = 1;
                break;

            case "F":
                $top = 5;
                $sub_info = 1;
                break;

            case "G":
                $top = 6;
                $sub_info = 1;
                break;

            case "H":
                $top = 7;
                $sub_info = 1;
                break;

            case "I":
                $top = 8;
                $sub_info = 1;
                break;

            case "J":
                $top = 9;
                $sub_info = 1;
                break;

            case "K":
                $top = 10;
                $sub_info = 1;
        }
        if ($sub_info == 0) {
            $S_id = splitx($S_list, ",", $top);
        } else {
            $S_id = splitx($S_sublist, ",", $top);
        }
    }
    $sql = "select * from ".TABLE."psort where S_del=0 and S_type=" . $S_type . " order by S_id asc limit 1";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $S_aid = $row["S_id"];
    }
    if ($S_id == 0) {
        $S_id_info = "";
    } else {
        $sql = "select * from ".TABLE."psort where S_del=0 and S_type=" . $S_type . " and S_id=" . $S_id;
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if (mysqli_num_rows($result) > 0) {
            $S_sub = $row["S_sub"];
        }
        if ($S_sub != 0) {
            $S_id_info = "and S_id=" . $S_id;
        } else {
            $S_id_info = "and S_sub=" . $S_id;
        }
    }
    $x = 0;
    if ($S_id !== "0") {
        $S_pic = getrx("select * from ".TABLE."psort where S_id=" . $S_id,"S_pic");
        $S_title = lang(getrx("select * from ".TABLE."psort where S_id=" . $S_id,"S_title"));
        $S_description = lang(getrx("select * from ".TABLE."psort where S_id=" . $S_id,"S_description"));
        $S_id = getrx("select * from ".TABLE."psort where S_id=" . $S_id,"S_id");
        $S_entitle = lang(getrx("select * from ".TABLE."psort where S_id=" . $S_id,"S_entitle"));
    } else {
        if ($S_type == 0) {
            $S_id = $row["S_id"];
            $S_title = lang($C_psorttitle);
            $S_entitle = lang($C_psortentitle);
        } else {
            $S_id = $row["S_id"];
            $S_title = "案例中心";
            $S_entitle = "case";
        }
    }
    $psort = "{\"S_id\":\"" . $S_id . "\",\"S_title\":\"" . $S_title . "\",\"S_description\":\"" . $S_description . "\",\"S_entitle\":\"" . $S_entitle . "\",\"S_pic\":\"http://" . $C_domain . $C_dir . $S_pic . "\"}";

	if($S_page==1){
	    $sql="select * from ".TABLE."product,".TABLE."psort where P_del=0 and S_del=0 and P_sort=S_id and S_type=".intval($S_type)." ".$S_id_info." and S_show=1 order by P_top desc,P_order asc,P_id desc ".$num_info;
	}else{
	    $sql="select * from ".TABLE."product,".TABLE."psort where P_del=0 and S_del=0 and P_sort=S_id and S_type=".intval($S_type)." ".$S_id_info." and S_show=1 order by P_top desc,P_order asc,P_id desc limit ".$num*($S_page-1).",".$num;
	}

    $sql = trim($sql, "\xEF\xBB\xBF");
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $P_title = lang($row["P_title"]);
            $P_short = lang($row["P_short"]);
            $P_id = $row["P_id"];
            if ($row["P_time"] == "") {
                $P_time = "2017-1-1";
            } else {
                $P_time = $row["P_time"];
            }
            $P_date = date("Y", strtotime($P_time)) . "-" . date("m", strtotime($P_time)) . "-" . date("d", strtotime($P_time));
            $i = $x;
            $j = $x + 1;
            if ($row["P_path"] == "" || is_null($row["P_path"])) {
                $P_path = "media/|media/|media/|media/|media/|media/|media/|media/|media/|media/|media/|media/|media/";
            } else {
                $P_path = "http://" . $C_domain . $C_dir . $row["P_path"] . "|media/|media/|media/|media/|media/|media/|media/|media/|media/|media/|media/|media/";
            }
            $P_pic = splitx(splitx($P_path, "|", 0) , "__", 0);
            $P_thumb = splitx(splitx($P_path, "|", 0) , "__", 0);
            $P_pic1 = splitx(splitx($P_path, "|", 0) , "__", 0);
            $P_pic2 = splitx(splitx($P_path, "|", 1) , "__", 0);
            $P_pic3 = splitx(splitx($P_path, "|", 2) , "__", 0);
            $P_pic4 = splitx(splitx($P_path, "|", 3) , "__", 0);
            $P_pic5 = splitx(splitx($P_path, "|", 4) , "__", 0);
            $P_price = round($row["P_price"], 2);
            $productlist = $productlist . "{\"P_id\":\"" . $P_id . "\",\"P_time\":\"" . $P_time . "\",\"P_title\":\"" . gljson($P_title) . "\",\"P_short\":\"" . gljson($P_short) . "\",\"P_date\":\"" . $P_date . "\",\"P_pic\":\"" . $P_pic . "\",\"P_thumb\":\"" . $P_thumb . "\",\"P_pic1\":\"" . $P_pic1 . "\",\"P_pic2\":\"" . $P_pic2 . "\",\"P_pic3\":\"" . $P_pic3 . "\",\"P_pic4\":\"" . $P_pic4 . "\",\"P_pic5\":\"" . $P_pic5 . "\",\"P_price\":\"" . $P_price . "\"},";
            $x = $x + 1;
        }
    }
    if ($psort == "") {
        $psort = "[]";
    }
    $sql = "select * from ".TABLE."psort where S_del=0 and S_sub=0 and S_type=0 order by S_order,S_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $psortlist2 = $psortlist2 . "{\"S_title\":\"" . lang($row["S_title"]) . "\",\"S_id\":\"" . $row["S_id"] . "\"},";
        }
    }
    $psortlist2 = substr($psortlist2, 0, strlen($psortlist2) - 1);
    $psort2 = getrx("select * from ".TABLE."psort where S_id=" . $S_id,"S_sub");
    if ($psort2 == 0) {
        $sql = "select * from ".TABLE."psort where S_del=0 and S_sub=" . $S_id . " and S_type=0 order by S_order,S_id desc";
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $psortlist = $psortlist . "{\"S_title\":\"" . lang($row["S_title"]) . "\",\"S_id\":\"" . $row["S_id"] . "\"},";
            }
        }
        $psort2 = $S_id;
    } else {
        $sql = "select * from ".TABLE."psort where S_del=0 and S_sub=" . $psort2 . " and S_type=0 order by S_order,S_id desc";
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $psortlist = $psortlist . "{\"S_title\":\"" . lang($row["S_title"]) . "\",\"S_id\":\"" . $row["S_id"] . "\"},";
            }
        }
    }
    $productlist = substr($productlist, 0, strlen($productlist) - 1);
    $psortlist = substr($psortlist, 0, strlen($psortlist) - 1);
    $api = "{\"productlist\":[" . $productlist . "],\"psortlist\":[" . $psortlist . "],\"psortlist2\":[" . $psortlist2 . "],\"psort\":" . $psort . ",\"psort2\":\"" . $psort2 . "\"}";
    break;

case "product_info":
    $sql = "Select * from ".TABLE."product,".TABLE."psort where P_del=0 and S_del=0 and P_sort=S_id and P_id=" . $id;
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $P_title = lang($row["P_title"]);
        $P_price = $row["P_price"];
        $P_time = $row["P_time"];
        $P_buy = $row["P_buy"];
        $P_unlogin = $row["P_unlogin"];
        $P_top = $row["P_top"];
        $P_content = str_Replace("{@SL_安装目录}", "http://" . $C_domain . $C_dir, lang($row["P_content"]));
        $P_content = str_Replace("class","alt",$P_content);
        $P_short = lang($row["P_short"]);
        $P_path = $row["P_path"];
        $P_sort = $row["P_sort"];
        $P_shuxing = $row["P_shuxing"];
        $P_pagetitle = lang($row["P_pagetitle"]);
        $P_keywords = lang($row["P_keywords"]);
        $P_description = lang($row["P_description"]);
        $P_name = $row["P_name"];
        $P_email = $row["P_email"];
        $P_address = $row["P_address"];
        $P_mobile = $row["P_mobile"];
        $P_postcode = $row["P_postcode"];
        $P_qq = $row["P_qq"];
        $P_remark = $row["P_remark"];
        $P_sell = $row["P_sell"];
        $P_sence = $row["P_sence"];
        $P_link = $row["P_link"];
        $S_type = $row["S_type"];
    }
    $pic = explode("|", $P_path);
    for ($i = 0; $i < count($pic); $i++) {
        if (strpos($pic[$i], "__") !== false) {
            $info = splitx($pic[$i], "__", 1);
        } else {
            $info = "";
        }
        $pics = $pics . "{\"pic\":\"http://" . $C_domain . $C_dir . splitx($pic[$i], "__", 0) . "\",\"info\":\"" . $info . "\"},";
    }
    if (strlen($pics) > 0) {
        $pics = substr($pics, 0, strlen($pics) - 1);
    }
    

	if($P_shuxing!=""){
		$shuxing = explode("@", $P_shuxing);
	    for ($i = 0; $i < count($shuxing); $i++) {
	        $zhi = explode("|", splitx($shuxing[$i], "_", 1));
	        $price = explode("|", splitx($shuxing[$i], "_", 2));
	        for ($j = 0; $j < count($zhi); $j++) {
	            if ($j == 0) {
	                $checked = "true";
	            } else {
	                $checked = "false";
	            }
	            $z = $z . "{\"ztitle\":\"" . lang($zhi[$j]) . "\",\"zprice\":\"" . $price[$j] . "\",\"zid\":\"" . $i . "-" . $price[$j] . "\",\"check\":\"" . $checked . "\"},";
	        }
	        if (strlen($z) > 0) {
	            $z = substr($z, 0, strlen($z) - 1);
	        }
	        $sx = $sx . "{\"shuxing\":\"" . lang(splitx($shuxing[$i], "_", 0)) . "\",\"zhi\":[" . $z . "]},";
	        $plus = $plus . "0,";
	        $z = "";
	    }
	}

    if (strlen($sx) > 0) {
        $sx = substr($sx, 0, strlen($sx) - 1);
    }
    if (strlen($plus) > 0) {
        $plus = substr($plus, 0, strlen($plus) - 1);
    }
    $api = "{\"P_id\":\"" . $id . "\",\"P_title\":\"" . gljson($P_title) . "\",\"P_price\":\"" . $P_price . "\",\"P_time\":\"" . $P_time . "\",\"P_buy\":\"" . $P_buy . "\",\"P_top\":\"" . $P_top . "\",\"P_content\":\"" . gljson($P_content) . "\",\"P_pics\":[" . $pics . "],\"P_sort\":\"" . $P_sort . "\",\"P_description\":\"" . $P_description . "\",\"S_type\":\"" . $S_type . "\",\"P_pic\":\"http://" . $C_domain . $C_dir . splitx(splitx($P_path, "|", 0) , "__", 0) . "\",\"P_shuxing\":[" . $sx . "],\"plus\":[" . $plus . "]}";
    break;

case "slide_list";
$sql = "select * from ".TABLE."wapslide order by S_id desc";
$result = mysqli_query($conn, $sql);
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $slidelist = $slidelist . "{\"S_id\":" . $row["S_id"] . ",\"S_title\":\"" . lang($row["S_title"]) . "\",\"S_content\":\"" . gljson(lang($row["S_content"])) . "\",\"S_order\":" . $row["S_order"] . ",\"S_link\":\"" . $row["S_link"] . "\",\"S_pic\":\"http://" . $C_domain . $C_dir . $row["S_pic"] . "\"},";
    }
    $slidelist = substr($slidelist, 0, strlen($slidelist) - 1);
}
$api = "{\"slidelist\":[" . $slidelist . "]}";
break;

case "search":
    $sql = "select * from ".TABLE."text where T_del=0 and (T_title like '%" . $keyword . "%' || T_content like '%" . $keyword . "%' ) order by T_order,T_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $list = $list . "{\"pic\":\"http://" . $C_domain . $C_dir . $row["T_pic"] . "\",\"title\":\"" . gljson(lang($row["T_title"])) . "\",\"content\":\"" . gljson(mb_substr(strip_tags(lang($row["T_content"])) , 0, 100,"utf-8")) . "\",\"id\":\"" . $row["T_id"] . "\",\"type\":\"text\"},";
        }
    }
    $sql = "select * from ".TABLE."news where N_del=0 and (N_title like '%" . $keyword . "%' || N_content like '%" . $keyword . "%' ) order by N_order,N_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $list = $list . "{\"pic\":\"http://" . $C_domain . $C_dir . $row["N_pic"] . "\",\"title\":\"" . gljson(lang($row["N_title"])) . "\",\"content\":\"" . gljson(mb_substr(strip_tags(lang($row["N_content"])) , 0, 100,"utf-8")) . "\",\"id\":\"" . $row["N_id"] . "\",\"type\":\"newsinfo\"},";
        }
    }
    $sql = "select * from ".TABLE."product where P_del=0 and (P_title like '%" . $keyword . "%' || P_content like '%" . $keyword . "%' ) order by P_order,P_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $list = $list . "{\"pic\":\"http://" . $C_domain . $C_dir . splitx(splitx($row["P_path"], "|", 0) , "__", 0) . "\",\"title\":\"" . gljson(lang($row["P_title"])) . "\",\"content\":\"" . gljson(mb_substr(strip_tags(lang($row["P_content"])) , 0, 100,"utf-8")) . "\",\"id\":\"" . $row["P_id"] . "\",\"type\":\"productinfo\"},";
        }
    }
    $sql = "select * from ".TABLE."form where F_del=0 and (F_title like '%" . $keyword . "%') order by F_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $list = $list . "{\"pic\":\"http://" . $C_domain . $C_dir . $row["F_pic"] . "\",\"title\":\"" . gljson(lang($row["F_title"])) . "\",\"content\":\"" . gljson(mb_substr(strip_tags(lang($row["F_title"])) , 0, 100,"utf-8")) . "\",\"id\":\"" . $row["F_id"] . "\",\"type\":\"form\"},";
        }
    }
    $list = substr($list, 0, strlen($list) - 1);
    $api = "{\"searchlist\":[" . $list . "]}";
    break;

case "guestbook";
$G_title = $_POST["G_title"];
$G_name = $_POST["G_name"];
$G_mail = $_POST["G_mail"];
$G_phone = $_POST["G_phone"];
$G_msg = $_POST["G_msg"];
mysqli_query($conn, "insert into ".TABLE."guestbook(G_title,G_name,G_phone,G_email,G_Msg,G_time) values('" . Replace_Text($G_title) . "','" . Replace_Text($G_name) . "','" . Replace_Text($G_phone) . "','" . Replace_Text($G_mail) . "','" . Replace_Text($G_msg) . "','" . date('Y-m-d H:i:s') . "')");
echo "success";
break;

case "contact":
    $sql = "Select * from ".TABLE."contact";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $C_address = lang($row["C_address"]);
        $C_zb = $row["C_zb"];
        $C_title = lang($row["C_title"]);
        $C_entitle = lang($row["C_entitle"]);
        $C_content = str_Replace("{@SL_安装目录}", "http://" . $C_domain . $C_dir, lang($row["C_content"]));
        $C_content = str_Replace("class","alt",$C_content);
        $C_map = $row["C_map"];
    }
    $api = "{\"C_title\":\"" . $C_title . "\",\"C_entitle\":\"" . $C_entitle . "\",\"C_address\":\"" . $C_address . "\",\"C_zb\":\"" . $C_zb . "\",\"C_map\":\"" . $C_map . "\",\"C_content\":\"" . gljson($C_content) . "\",\"C_longitude\":\"" . splitx($C_zb, ",", 0) . "\",\"C_latitude\":\"" . splitx($C_zb, ",", 1) . "\"}";
break;

case "formsave":

if($M_id==""){
    $M_id=getrx("select * from ".TABLE."member where M_login='未提供'","M_id");
}
$R_time=date('Y-m-d H:i:s');
$R_rid=gen_key(15);
foreach ($_POST as $x=>$value) {
    if ($x>0){
        if($_POST[$x]==""){
            $y="未填写";
        }else{
            $y=t($_POST[$x]);
        }
        mysqli_query($conn,"Insert into ".TABLE."response(R_cid,R_content,R_time,R_rid,R_member) values(".$x.",'".htmlspecialchars($y)."','".$R_time."','".$R_rid."',".$M_id.")");
    }
}
$api = "{\"code\":\"success\"}";
break;

case "query":
$Q_sort = $_POST["Q_sort"];
$Q_code = $_POST["Q_code"];
$sql = "select * from ".TABLE."query where Q_sort=" . $Q_sort . " and Q_code='" . $Q_code . "'";
$result = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($result);
if (mysqli_num_rows($result) > 0) {
    mysqli_query($conn, "update ".TABLE."query set Q_times=Q_times+1 where Q_code='" . $Q_code . "'");
    if (strpos($row["Q_content"], "__") === false) {
        $qcode = "查询结果：" . $row["Q_content"];
    } else {
        $qcode = $qcode . "<table class=\"table table-hover\">";
        $qcode = $qcode . "<tr><th>时间</th><th>进度</th></tr>";
        $code = exlpode("|", $row["Q_content"]);
        for ($j = 0; $j < count($code); $j++) {
            $Q_time = splitx($code[$j], "__", 0);
            $Q_result = splitx($code[$j], "__", 1);
            $qcode = $qcode . "<tr><td>" . $Q_time . "</td><td>" . $Q_result . "</td></tr>";
        }
        $qcode = $qcode . "</table>";
    }
    $sql2 = "select * from ".TABLE."response where R_rid='" . $Q_code . "'";
    $result2 = mysqli_query($conn, $sql2);
    if (mysqli_num_rows($result2) > 0) {
        while ($row2 = mysqli_fetch_assoc($result2)) {
            $res = $res . "<div class=\"col-md-4 col-xs-6\" style=\"font-size: 15px;padding: 5px;\"><b>" . lang(getrx("select * from ".TABLE."content where C_id=" . $row2["R_cid"],"C_title")) . "</b>:" . $row2["R_content"] . "</div>";
        }
    }
    echo "第" . $row["Q_times"] . "次查询";
    if ($res != "") {
        echo "<div class=\"form-group\"><label for=\"firstname\" class=\"col-sm-2 control-label\">提交信息</label><div class=\"col-sm-10\">" . $res . "</div></div>";
    }
    echo $qcode;
    die();
} else {
    echo "未查询到您输入的编号！";
}
break;

case "form";
$sql = "select * from ".TABLE."form where F_id=" . $id;
$result = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($result);
if (mysqli_num_rows($result) > 0) {
    if ($row["F_type"] == 0) {
        $sql2 = "select * from ".TABLE."content where C_del=0 and C_fid=" . $row["F_id"] . " order by C_order";
        $result2 = mysqli_query($conn, $sql2);
        if (mysqli_num_rows($result2) > 0) {
            while ($row2 = mysqli_fetch_assoc($result2)) {
                if ($row2["C_type"] == "radio" || $row2["C_type"] == "checkbox" || $row2["C_type"] == "option") {
                    $c = explode("|", lang($row2["C_content"]));
                    for ($i = 0; $i < count($c); $i++) {
                        $clist = $clist . "{\"con\":\"" . $c[$i] . "\",\"index\":\"" . $i . "\"},";
                    }
                    $clist = substr($clist, 0, strlen($clist) - 1);
                } else {
                    $clist = "";
                }
                $contentlist = $contentlist . "{\"C_id\":" . $row2["C_id"] . ",\"C_order\":" . $row2["C_order"] . ",\"C_title\":\"" . lang($row2["C_title"]) . "\",\"C_bz\":\"" . lang($row2["C_bz"]) . "\",\"C_content\":[" . $clist . "],\"C_type\":\"" . $row2["C_type"] . "\"},";
                $clist = "";
            }
            $contentlist = substr($contentlist, 0, strlen($contentlist) - 1);
        }
    }
    $api = "{\"F_id\":" . $row["F_id"] . ",\"F_title\":\"" . lang($row["F_title"]) . "\",\"F_entitle\":\"" . lang($row["F_entitle"]) . "\",\"F_pic\":\"http://" . $C_domain . $C_dir . $row["F_pic"] . "\",\"F_type\":\"" . $row["F_type"] . "\",\"F_yz\":\"" . $row["F_yz"] . "\",\"F_qsort\":\"" . $row["F_qsort"] . "\",\"Q_content\":\"" . getrx("select * from ".TABLE."qsort where S_id=" . $row["F_qsort"],"S_content") . "\",\"content_list\":[" . $contentlist . "]}";
}
break;

case "login";
$sql = "select * from ".TABLE."member where M_del=0 and M_login='" . $M_login . "' and M_pwd='" . md5($M_pwd) . "'";
$result = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($result);
if (mysqli_num_rows($result) > 0) {
    $code = "success";
    $M_id = $row["M_id"];
    $M_login = $row["M_login"];
    $M_pwd = $row["M_pwd"];
    $M_pic = $row["M_pic"];
    $M_money = $row["M_money"];
    if (substr($M_pic, 0, 4) != "http") {
        $M_pic = "http://" . $C_domain . $C_dir . "media/" . $M_pic;
    }
    $M_lv = $row["M_lv"];
    $M_lv = lang(getrx("select * from ".TABLE."lv where L_id=" . $M_lv,"L_title"));
} else {
    $code = "fail";
}
$api = "{\"code\":\"" . $code . "\",\"M_id\":\"" . $M_id . "\",\"M_login\":\"" . $M_login . "\",\"M_pwd\":\"" . MD5($M_pwd) . "\",\"M_lv\":\"" . $M_lv . "\",\"M_money\":\"" . $M_money . "\",\"M_pic\":\"" . $M_pic . "\"}";
break;

case "reg":
    $M_pwd2 = $_REQUEST["M_pwd2"];
    $M_email = $_REQUEST["M_email"];
    if ($M_pwd !== $M_pwd2) {
        $code = "error1";
        $code_info = "两次密码不一致";
    } else {
        if ($M_login != "" && $M_pwd != "" && $M_pwd2 != "" && $M_email != "") {
            if (strpos($M_email, "@") ===false) {
                $code = "error2";
                $code_info = "输入一个可用邮箱";
            } else {
                $sql = "Select * from ".TABLE."member where M_del=0 and M_login='" . $M_login . "'";
                $result = mysqli_query($conn, $sql);
                $row = mysqli_fetch_assoc($result);
                if (mysqli_num_rows($result) > 0) {
                    $code = "error3";
                    $code_info = "用户名已被占用";
                } else {
                    $sql2 = "Select * from ".TABLE."member Where M_del=0 and M_email='" . $M_email . "'";
                    $result2 = mysqli_query($conn, $sql2);
                    $row2 = mysqli_fetch_assoc($result2);
                    if (mysqli_num_rows($result2) > 0) {
                        $code = "error4";
                        $code_info = "邮箱已被占用";
                    } else {
                        mysqli_query($conn, "insert into ".TABLE."member(M_login,M_pwd,M_email,M_fen,M_pic,M_regtime,M_type) values('" . $M_login . "','" . md5($M_pwd) . "','" . $M_email . "',0,'member.jpg','" . date('Y-m-d H:i:s') . "',1)");
                        
                        $sql = "select * from ".TABLE."member where M_login='".$M_login."' and M_del=0 order by M_id desc limit 1";
                        $result = mysqli_query($conn, $sql);
                        $row = mysqli_fetch_assoc($result);
                        $M_id = $row["M_id"];
                        $M_pic = $row["M_pic"];
                        $M_money = $row["M_money"];
                        if (substr($M_pic, 0, 4) != "http") {
                            $M_pic = "http://" . $C_domain . $C_dir . "media/" . $M_pic;
                        }
                        uplevel($M_id);
                        $code = "success";
                        $code_info = "注册成功";
                        $M_lv = getrx("select * from ".TABLE."member where M_id=" . $M_id,"M_lv");
                        $M_lv = lang(getrx("select * from ".TABLE."lv where L_id=" . $M_lv,"L_title"));
                    }
                }
            }
        } else {
            $code = "error5";
            $code_info = "请填全信息";
        }
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\",\"M_id\":\"" . $M_id . "\",\"M_login\":\"" . $M_login . "\",\"M_pwd\":\"" . MD5($M_pwd) . "\",\"M_lv\":\"" . $M_lv . "\",\"M_money\":\"" . $M_lv . "\",\"M_pic\":\"" . $M_pic . "\"}";
    break;

case "editpwd";
if (!check($M_id, $M_pwd)) {
    die();
}
$M_pwd1 = $_REQUEST["M_pwd1"];
$M_pwd2 = $_REQUEST["M_pwd2"];
$sql = "select * from ".TABLE."member where M_del=0 and M_id=" . $M_id . " and M_pwd='" . $M_pwd1 . "'";
$result = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($result);
if (mysqli_num_rows($result) > 0) {
    $code = "success";
    mysqli_query($conn, "update ".TABLE."member set M_pwd='" . $M_pwd2 . "' where M_id=" . $M_id);
} else {
    $code = "fail";
}
$api = "{\"code\":\"" . $code . "\"}";
break;

case "wxlogin":
    $code = $_REQUEST["code"];
    $info = GetBody("https://api.weixin.qq.com/sns/jscode2session?appid=" . $C_wxappID . "&secret=" . $C_wxappSecret . "&js_code=" . $code . "&grant_type=authorization_code", "");
    $info = json_decode($info);
    $openid = $info->openid;
    $session_key = $info->session_key;
    $sql = "select * from ".TABLE."member where M_del=0 and M_qqid='" . $openid . "' and not M_qqid=''";

    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $state = "success";
        $M_id = $row["M_id"];
        $M_login = $row["M_login"];
        $M_pwd = $row["M_pwd"];
        $M_lv = $row["M_lv"];
        $M_money = $row["M_money"];
        $M_lv = lang(getrx("select * from ".TABLE."lv where L_id=" . $M_lv,"L_title"));
        $M_pic = $row["M_pic"];
        if (substr($M_pic, 0, 4) != "http") {
            $M_pic = "http://" . $C_domain . $C_dir . "media/" . $M_pic;
        }
        $info = "{\"M_id\":\"" . $M_id . "\",\"M_login\":\"" . $M_login . "\",\"M_pwd\":\"" . md5($M_pwd) . "\",\"M_lv\":\"" . $M_lv . "\",\"M_money\":\"" . $M_money . "\",\"M_pic\":\"" . $M_pic . "\"}";
    } else {
        $state = "fail";
        $info = "";
    }
    $api = "{\"state\":\"" . $state . "\",\"session_key\":\"" . $session_key . "\",\"openid\":\"" . $openid . "\",\"info\":[" . $info . "]}";
    break;



case "wxlogin2":
    $encryptedData = str_replace(" ","+",$_POST["encryptedData"]);
    $iv = str_replace(" ","+",$_POST["iv"]);
    $sessionkey = str_replace(" ","+",$_POST["session_key"]);

    $pc = new WXBizDataCrypt($C_wxappID, $sessionkey);
    $errCode = $pc->decryptData($encryptedData, $iv, $data);

    if ($errCode == 0 && json_decode($data)->openId!="") {
        $info = json_decode($data);
         mysqli_query($conn, "insert into ".TABLE."member(M_login,M_pwd,M_qqid,M_pic,M_fen,M_regtime,M_add,M_name,M_subscribe,M_type) values('" . $info->nickName . "','" . $info->openId . "','" . $info->openId . "','" . $info->avatarUrl . "',0,'" . date('Y-m-d H:i:s') . "','" . $info->country . "-" . $info->province . "-" . $info->city . "','" . $info->nickName . "',0,1)");

        $sql = "select * from ".TABLE."member where M_del=0 and M_qqid='".$info->openId."'";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if (mysqli_num_rows($result) > 0) {
            $state = "success";
            $M_id = $row["M_id"];
            $M_login = $row["M_login"];
            $M_pwd = $row["M_pwd"];
            $M_pic = $row["M_pic"];
            $M_money = $row["M_money"];
            if (substr($M_pic, 0, 4) != "http") {
                $M_pic = "http://" . $C_domain . $C_dir . "media/" . $M_pic;
            }
        }
        uplevel($M_id);
        $M_lv = getrx("select * from ".TABLE."member where M_id=" . $M_id,"M_lv");
        $M_lv = lang(getrx("select * from ".TABLE."lv where L_id=" . $M_lv,"L_title"));
        $code = "success";
    }else{
    	$code = "error1".$sessionkey;
    }

    $api = "{\"code\":\"" . $code . "\",\"M_id\":\"" . $M_id . "\",\"M_login\":\"" . $M_login . "\",\"M_pwd\":\"" . md5($M_pwd) . "\",\"M_lv\":\"" . $M_lv . "\",\"M_money\":\"" . $M_money . "\",\"M_pic\":\"" . $M_pic . "\"}";
    break;


case "cart2":
$O_ids = $_REQUEST["O_id"];
$openid = $_REQUEST["openid"];
$O_id = explode(",", $O_ids);
for ($i = 0; $i < count($O_id); $i++) {
    mysqli_query($conn, "update ".TABLE."orders set O_state=7 where O_id=" . intval($O_id[$i]));
}
$api = "{\"code\":\"success\"}";
break;

case "order";
if (!check($M_id, $M_pwd)) {
    die();
}
$all = 0;
$state = $_REQUEST["state"];
if ($M_id == "") {
    $M_id = 0;
}
if ($state !== "") {
    $state_info = "and O_state=" . $state;
} else {
    $state_info = "";
}
$sql = "select * from ".TABLE."orders,".TABLE."product,".TABLE."lv,".TABLE."member where M_del=0 and P_del=0 and M_lv=L_id and O_member=M_id and O_pid=P_id and O_member=" . $M_id . " " . $state_info . " order by O_id desc";
$result = mysqli_query($conn, $sql);
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row["O_state"] == 0) {
            $O_state = lang("未付款/l/No payment");
        }
        if ($row["O_state"] == 1) {
            $O_state = lang("已付款/l/Already paid");
        }
        if ($row["O_state"] == 2) {
            $O_state = lang("已发货/l/Already shipped)");
        }
        if ($row["O_state"] == 3) {
            $O_state = lang("已确认/l/confirmed");
        }
        if ($row["O_state"] == 4) {
            $O_state = lang("已申请退款/l/Has applied for a refund");
        }
        if ($row["O_state"] == 5) {
            $O_state = lang("已退款/l/Refunded");
        }
        if ($row["O_state"] == 6) {
            $O_state = lang("货到付款/l/Refunded");
        }
        if ($row["O_state"] == 7) {
            $O_state = lang("转账汇款/l/Refunded");
        }
        $O_shuxing = $row["O_shuxing"];
        $shuxing = explode("|", $O_shuxing);
        for ($i = 0; $i < count($shuxing); $i++) {
            $sx = $sx . lang($shuxing[$i]) . " ";
        }
        $O_tradeno = $row["O_tradeno"];
        if ($O_tradeno == "" || is_null($O_tradeno)) {
            $O_tradeno = "未生成";
        }
        $order = $order . "{\"O_title\":\"" . lang($row["P_title"]) . "\",\"O_id\":\"" . $row["O_id"] . "\",\"O_pic\":\"http://" . $C_domain . $C_dir . splitx(splitx($row["P_path"], "|", 0) , "__", 0) . "\",\"O_price\":\"" . round($row["O_price"], 2) . "\",\"O_price2\":\"" . round($row["O_price"] * $row["L_discount"] * 0.01, 2) . "\",\"O_num\":\"" . $row["O_num"] . "\",\"O_money\":\"" . round($row["O_num"] * $row["O_price"] * $row["L_discount"] * 0.01, 2) . "\",\"O_state\":\"" . $O_state . "\",\"state\":\"" . $row["O_state"] . "\",\"O_shuxing\":\"" . $sx . "\",\"O_tradeno\":\"" . splitx($O_tradeno, "（", 0) . "\",\"O_time\":\"" . $row["O_time"] . "\"},";
        $ids = $ids . $row["O_id"] . ",";
        $all = round($all,2) + $row["O_num"] * $row["O_price"] * $row["L_discount"] * 0.01;
        $sx = "";
    }
}
$order = substr($order, 0, strlen($order) - 1);
$ids = substr($ids, 0, strlen($ids) - 1);
$api = "{\"order\":[" . $order . "],\"O_ids\":\"" . $ids . "\",\"all\":\"" . round($all, 2) . "\"}";
break;

case "member_news":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $sql = "select * from ".TABLE."news,".TABLE."nsort where N_del=0 and S_del=0 and N_sort=S_id and N_author='" . $M_login . "' order by N_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            if ($row["N_sh"] == 0) {
                $sh_info = lang("已通过/l/Already passed");
            }
            if ($row["N_sh"] == 1) {
                $sh_info = lang("未通过/l/not passed");
            }
            if ($row["N_sh"] == 2) {
                $sh_info = lang("未审核/l/Not audited");
            }
            $news = $news . "{\"N_title\":\"" . lang($row["N_title"]) . "\",\"N_id\":\"" . $row["N_id"] . "\",\"S_title\":\"" . lang($row["S_title"]) . "\",\"N_date\":\"" . $row["N_date"] . "\",\"sh_info\":\"" . $sh_info . "\"},";
        }
    }
    $news = substr($news, 0, strlen($news) - 1);
    $api = "{\"news\":[" . $news . "]}";
    break;

case "member_newsinfo":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $N_id = $_REQUEST["N_id"];
    if ($N_id == "") {
        $N_id = 0;
    }
    $sql = "select * from ".TABLE."news,".TABLE."nsort where N_del=0 and S_del=0 and N_sort=S_id and N_id=" . $N_id;
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $N_title = lang($row["N_title"]);
        $N_content = str_Replace("{@SL_安装目录}", "http://" . $C_domain . $C_dir, lang($row["N_content"]));
        $N_content = str_Replace("class","alt",$N_content);
        $N_date = $row["N_date"];
        $S_title = lang($row["S_title"]);
        $N_sort = $row["N_sort"];
    } else {
        $N_title = "";
        $N_content = "";
        $N_date = "";
        $S_title = "";
        $N_sort = "";
    }
    $api = "{\"N_title\":\"" . $N_title . "\",\"N_sort\":\"" . $N_sort . "\",\"N_date\":\"" . $N_date . "\",\"N_content\":\"" . gljson(strip_tags($N_content)) . "\"}";
    break;

case "product_sort":
    $S_sub = $_REQUEST["sub"];
    if ($S_sub == "0") {
        $sub_info = "S_sub!=0";
    } else {
        if ($S_sub == "x") {
            $sub_info = "S_sub=0";
        } else {
            $sub_info = "S_sub=" . $S_sub;
        }
    }
    $sql = "select * from ".TABLE."psort where S_del=0 and " . $sub_info . " and S_type=0 order by S_order,S_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $sort = $sort . "{\"S_id\":\"" . $row["S_id"] . "\",\"S_title\":\"" . lang($row["S_title"]) . "\",\"S_description\":\"" . lang($row["S_description"]) . "\",\"S_pic\":\"http://" . $C_domain . $C_dir . $row["S_pic"] . "\"},";
        }
    }
    $sort = substr($sort, 0, strlen($sort) - 1);
    $api = "{\"product_sort\":[" . $sort . "]}";
    break;

case "member_nsort";
$i = 0;
$sql = "select * from ".TABLE."nsort where S_del=0 and not S_sub=0 order by S_order,S_id desc";
$result = mysqli_query($conn, $sql);
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $sort = $sort . "{\"S_id\":\"" . $row["S_id"] . "\",\"S_title\":\"" . lang($row["S_title"]) . "\",\"index\":\"" . $i . "\"},";
        $i = $i + 1;
    }
}
$sort = substr($sort, 0, strlen($sort) - 1);
$api = "{\"nsort\":[" . $sort . "]}";
break;

case "editnews":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $N_id = $_REQUEST["N_id"];
    $N_title = $_POST["N_title"];
    $N_author = $_POST["N_author"];
    $N_date = $_POST["N_date"];
    $N_content = $_POST["N_content"];
    $N_sort = $_POST["N_sort"];
    if ($N_id == "" || $N_id == 0) {
        if ($N_title != "") {
            mysqli_query($conn, "
insert into ".TABLE."news(
N_title,
N_author,
N_view,
N_content,
N_sort,
N_date,
N_sh,
N_pic
)values(
'" . lang_add("", $N_title) . "',
'" . $M_login . "',
0,
'" . lang_add("", $N_content) . "',
" . $N_sort . ",
'" . $N_date . "',
2,
'media/20151019213836856.jpg'
)");
            $code = "success";
            $code_info = "提交成功，请等待审核";
        } else {
            $code = "error";
            $code_info = "请填全信息";
        }
    } else {
        if ($N_title != "") {
            mysqli_query($conn, "update ".TABLE."news set
N_title='" . lang_add(getrx("select * from ".TABLE."news where N_id=" . $N_id,"N_title") , $N_title) . "',
N_author='" . $M_login . "',
N_content='" . lang_add(getrx("select * from ".TABLE."news where N_id=" . $N_id,"N_content") , $N_content) . "',
N_sort=" . $N_sort . ",
N_date='" . $N_date . "',
N_sh=2
where N_id=" . $N_id);
            $code = "success";
            $code_info = "提交成功，请等待审核";
        } else {
            $code = "error";
            $code_info = "请填全信息";
        }
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "member_form":
    if (!check($M_id, $M_pwd)) {
        die();
    }

    $sql2 = "select F_id from ".TABLE."content,".TABLE."form,".TABLE."response where R_cid=C_id and C_fid=F_id and R_member=" . $M_id . " order by F_id";
    $result2 = mysqli_query($conn, $sql2);
    if (mysqli_num_rows($result2) > 0) {
        while ($row2 = mysqli_fetch_assoc($result2)) {
            $F_id = $row2["F_id"];
            $F_title = lang(getrx("select * from ".TABLE."form where F_id=$F_id","F_title"));

            $sql = "select * from ".TABLE."content where C_Fid=" . $F_id . " order by C_order";
            $result = mysqli_query($conn, $sql);
            if (mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    $aa = $aa . lang($row["C_title"]) . "|";
                }
            }

            $sql = "select distinct(R_rid),R_time,R_read,R_member from ".TABLE."response,".TABLE."content where R_Cid=C_id and C_fid=" . $F_id . " and R_member=" .  $M_id . " order by R_time";
            $result = mysqli_query($conn, $sql);
            if (mysqli_num_rows($result) > 0) {
                while ($row = mysqli_fetch_assoc($result)) {
                    $R_member = lang("未登录/l/Not logged");
                    if ($row["R_member"] != "") {
                        $R_member = $M_login;
                    }

                    $sql1 = "select * from ".TABLE."response,".TABLE."content where R_Cid=C_id and C_fid=" . $F_id . " and R_rid like '" . $row["R_rid"] . "' order by C_order";
                    $result1 = mysqli_query($conn, $sql1);
                    if (mysqli_num_rows($result1) > 0) {
                        while ($row1 = mysqli_fetch_assoc($result1)) {
                            $R_content = $row1["R_content"];
                            $bb = $bb . $R_content . "|";
                        }
                    }
                    if ($row["R_read"] == 1) {
                        $read_info = "已审核";
                    } else {
                        $read_info = "未审核";
                    }
                    $F_time = $row["R_time"];
                    $C_title = explode("|", $aa);
                    $C_content = explode("|", $bb);
                    for ($i = 0; $i < count($C_title) - 1; $i++) {
                        $xx = $xx . "{\"xx\":\"" . $C_title[$i] . "：" . $C_content[$i] . "\"},";
                    }
                    $xx = substr($xx, 0, strlen($xx) - 1);
                    if ($xx != "") {
                        $con = $con . "{\"F_title\":\"" . $F_title . "\",\"content\":[" . $xx . "],\"sh_info\":\"" . $read_info . "\",\"F_time\":\"" . $F_time . "\"},";
                    }
                    $aa = "";
                    $bb = "";
                    $xx = "";
                }
            }
        }
    }
    //$con = MoveR($con);
    //$con = str_replace("|", "", $con);
    $con = substr($con, 0, strlen($con) - 1);
    $api = "{\"form\":[" . $con . "]}";
    break;

case "list";
if (!check($M_id, $M_pwd)) {
    die();
}
$sql = "select * from ".TABLE."list where L_mid=" . $M_id . " and L_type=1 order by L_id desc";
$result = mysqli_query($conn, $sql);
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row["L_change"] > 0) {
            $C_info = "+";
        } else {
            $C_info = "";
        }
        switch ($row["L_sh"]) {
            case 0:
                $sh_info = "已通过";
                break;

            case 1:
                $sh_info = "未审核";
                break;

            case 2:
                $sh_info = "未通过";
        }
        $fenlist = $fenlist . "{\"L_title\":\"" . $row["L_title"] . "\",\"L_change\":\"" . $C_info . $row["L_change"] . "\",\"L_time\":\"" . $row["L_time"] . "\",\"L_no\":\"" . $row["L_no"] . "\",\"sh_info\":\"" . $sh_info . "\"},";
    }
}
$fenlist = substr($fenlist, 0, strlen($fenlist) - 1);
$sql = "select * from ".TABLE."list where L_mid=" . $M_id . " and L_type=0 order by L_id desc";
$result = mysqli_query($conn, $sql);
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row["L_change"] > 0) {
            $C_info = "+";
        } else {
            $C_info = "";
        }
        switch ($row["L_sh"]) {
            case 0:
                $sh_info = "已通过";
                break;

            case 1:
                $sh_info = "未审核";
                break;

            case 2:
                $sh_info = "未通过";
        }
        $moneylist = $moneylist . "{\"L_title\":\"" . $row["L_title"] . "\",\"L_change\":\"" . $C_info . $row["L_change"] . "\",\"L_time\":\"" . $row["L_time"] . "\",\"L_no\":\"" . $row["L_no"] . "\",\"sh_info\":\"" . $sh_info . "\"},";
    }
}
$moneylist = substr($moneylist, 0, strlen($moneylist) - 1);
$api = "{\"fen_list\":[" . $fenlist . "],\"money_list\":[" . $moneylist . "]}";
break;

case "lv":
    $sql = "select * from ".TABLE."lv order by L_order,L_id";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $lv = $lv . "{\"L_title\":\"" . lang($row["L_title"]) . "\",\"L_discount\":\"" . $row["L_discount"] . "\",\"L_fen\":\"" . $row["L_fen"] . "\"},";
        }
    }
    $lv = substr($lv, 0, strlen($lv) - 1);
    $api = "{\"lv\":[" . $lv . "]}";
    break;

case "role":
    if ($C_1yuan !== 0) {
        $role = $role . "{\"event\":\"每消费一元\",\"role\":\"+" . $C_1yuan . "\"},";
    }
    if ($C_1yuan !== 0) {
        $role = $role . "{\"event\":\"完善资料\",\"role\":\"+" . $C_data . "\"},";
    }
    if ($C_1yuan !== 0) {
        $role = $role . "{\"event\":\"每日签到\",\"role\":\"+" . $C_sign . "\"},";
    }
    if ($C_1yuan !== 0) {
        $role = $role . "{\"event\":\"邀请好友注册\",\"role\":\"+" . $C_Invitation . "\"},";
    }
    if ($C_1yuan !== 0) {
        $role = $role . "{\"event\":\"邀请好友消费1元\",\"role\":\"+" . $C_1yuan2 . "\"},";
    }
    $role = substr($role, 0, strlen($role) - 1);
    $api = "{\"role\":[" . $role . "]}";
    break;

case "member_info":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $sql = "Select * from ".TABLE."member,".TABLE."lv where M_del=0 and M_lv=L_id and M_id=" . $M_id;
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    $M_name = $row["M_name"];
    $M_qq = $row["M_QQ"];
    $M_add = $row["M_add"];
    $M_code = $row["M_code"];
    $M_email = $row["M_email"];
    $M_mobile = $row["M_mobile"];
    $api = "{\"M_id\":\"" . $M_id . "\",\"M_name\":\"" . $M_name . "\",\"M_qq\":\"" . $M_qq . "\",\"M_add\":\"" . $M_add . "\",\"M_code\":\"" . $M_code . "\",\"M_email\":\"" . $M_email . "\",\"M_mobile\":\"" . $M_mobile . "\"}";
    break;

case "editinfo":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $M_name = $_REQUEST["M_name"];
    $M_qq = $_REQUEST["M_qq"];
    $M_add = $_REQUEST["M_add"];
    $M_code = $_REQUEST["M_code"];
    if ($M_name != "") {
        mysqli_query($conn, "update ".TABLE."member set
M_qq='" . $M_qq . "',
M_add='" . $M_add . "',
M_name='" . $M_name . "',
M_code='" . $M_code . "'
where M_id=" . $M_id);
        $code = "success";
    } else {
        $code = "fail";
    }
    $api = "{\"code\":\"" . $code . "\"}";
    break;

case "getEmailCode";
$mailto = $_REQUEST["M_email"];
$edit_code = rand(10000, 99999);
$sql = "Select * from ".TABLE."member where M_del=0 and M_email='" . urldecode($mailto) . "' and not M_id=" . $M_id;
$result = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($result);
if (mysqli_num_rows($result) > 0) {
    $code = "error";
    $code_info = "邮箱已被占用";
} else {
    mysqli_query($conn, "update ".TABLE."member set M_pwdcode='" . $edit_code . "' where M_id=" . $M_id);
    sendmail("您的验证码", "您的验证码为 <b>" . $edit_code . "</b>，请妥善保管不要告诉他人。", urldecode($mailto));
    $code = "success";
    $code_info = "发送成功";
}
$api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
break;

case "getMobileCode":
    $mobileto = $_REQUEST["M_mobile"];
    $edit_code = rand(10000, 99999);
    $sql = "Select * from ".TABLE."member where M_del=0 and M_mobile='" . $mobileto . "' and not M_id=" . $M_id;
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $code = "error";
        $code_info = "手机号码已被占用";
    } else {
        mysqli_query($conn, "update ".TABLE."member set M_pwdcode='" . $mobileto . "' where M_id=" . $M_id);
        sendmobile("【" . $C_smssign . "】您的验证码为" . $mobileto . "；1分钟内有效,请尽快验证！", $mobileto);
        $code = "success";
        $code_info = "发送成功";
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "editemail":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $M_code = $_REQUEST["M_code"];
    $M_email = $_REQUEST["M_email"];
    $sql = "Select * from ".TABLE."member Where M_del=0 and M_id=" . $M_id . " and M_pwdcode='" . $M_code . "'";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $code = "success";
        $code_info = "修改成功";
        mysqli_query($conn, "update ".TABLE."member set M_email='" . $M_email . "' where M_id=" . $M_id);
    } else {
        $code = "error";
        $code_info = "验证码错误";
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "editmobile":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $M_code = $_REQUEST["M_code"];
    $M_mobile = $_REQUEST["M_mobile"];
    $sql = "Select * from ".TABLE."member Where M_id=" . $M_id . " and M_pwdcode='" . $M_code . "'";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $code = "success";
        $code_info = "修改成功";
        mysqli_query($conn, "update ".TABLE."member set M_mobile='" . $M_mobile . "' where M_id=" . $M_id);
    } else {
        $code = "error";
        $code_info = "验证码错误";
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "member_invoice":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $sql = "select * from ".TABLE."invoice where I_mid=" . $M_id . " order by I_id desc";
    $result = mysqli_query($conn, $sql);
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            switch ($row["I_sh"]) {
                case 1:
                    $sh_info = "已通过";
                    break;

                case 0:
                    $sh_info = "未审核";
                    break;

                case 2:
                    $sh_info = "未通过";
            }
            $invoice = $invoice . "{\"I_company\":\"" . $row["I_company"] . "\",\"I_no\":\"" . $row["I_no"] . "\",\"I_list\":\"" . $row["I_list"] . "\",\"I_money\":\"" . round($row["I_money"], 2) . "\",\"I_time\":\"" . $row["I_time"] . "\",\"sh_info\":\"" . $sh_info . "\"},";
        }
    }
    $invoice = substr($invoice, 0, strlen($invoice) - 1);
    $api = "{\"invoice\":[" . $invoice . "]}";
    break;

case "addinvoice":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $I_company = $_POST["I_company"];
    $I_no = $_POST["I_no"];
    $I_list = $_POST["I_list"];
    $I_money = $_POST["I_money"];
    if ($I_company != "") {
        mysqli_query($conn, "insert into ".TABLE."invoice(
I_company,
I_mid,
I_no,
I_list,
I_money,
I_time,
N_sh
)values(
'" . $I_company . "',
" . $M_id . ",
'" . $I_no . "',
'" . $I_list . "',
" . $I_money . ",
'" . date('Y-m-d H:i:s') . "',
0
)");
        $code = "success";
        $code_info = "提交成功，请等待审核!";
    } else {
        $code = "success";
        $code_info = "请填全资料!";
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "mobileLoginCode":
    $M_mobile = $_REQUEST["M_mobile"];
    $login_code = rand(10000, 99999);
    $sql = "Select * from ".TABLE."member where M_del=0 and M_mobile='" . $M_mobile . "'";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        mysqli_query($conn, "update ".TABLE."member set M_pwdcode='" . $login_code . "' where M_mobile='" . $M_mobile . "'");
    } else {
        mysqli_query($conn, "insert into ".TABLE."member(M_login,M_pwd,M_mobile,M_pwdcode,M_fen,M_pic,M_regtime,M_type) values('" . $M_mobile . "','" . $M_mobile . "','" . $M_mobile . "','" . $login_code . "',0,'member.jpg','" . date('Y-m-d H:i:s') . "',1)");
        $sql = "Select * from ".TABLE."member where M_del=0 and order by M_id desc limit 1";
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        $M_id = $row["M_id"];
        uplevel($M_id);
    }
    sendmobile("【" . $C_smssign . "】您的验证码为" . $login_code . "；1分钟内有效,请尽快验证！", $M_mobile);
    $code = "success";
    $code_info = "发送成功";
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "mobileLogin";
$M_mobile = $_REQUEST["M_mobile"];
$M_code = $_REQUEST["M_code"];
$sql = "select * from ".TABLE."member where M_del=0 and M_mobile='" . $M_mobile . "' and M_pwdcode='" . $M_code . "'";
$result = mysqli_query($conn, $sql);
$row = mysqli_fetch_assoc($result);
if (mysqli_num_rows($result) > 0) {
    $code = "success";
    $M_id = $row["M_id"];
    $M_login = $row["M_login"];
    $M_pic = $row["M_pic"];
    if (substr($M_pic, 0, 4) != "http") {
        $M_pic = "http://" . $C_domain . $C_dir . "media/" . $M_pic;
    }
    $M_lv = $row["M_lv"];
    $M_lv = lang(getrx("select * from ".TABLE."lv where L_id=" . $M_lv,"L_title"));
} else {
    $code = "fail";
}
$api = "{\"code\":\"" . $code . "\",\"M_id\":\"" . $M_id . "\",\"M_login\":\"" . $M_login . "\",\"M_lv\":\"" . $M_lv . "\",\"M_pic\":\"" . $M_pic . "\"}";
break;

case "foundCode":
    $mailto = $_REQUEST["M_email"];
    $edit_code = rand(10000, 99999);
    $sql = "Select * from ".TABLE."member where M_del=0 and M_email='" . urldecode($mailto) . "'";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        mysqli_query($conn, "update ".TABLE."member set M_pwdcode='" . $edit_code . "' where M_email='" . $mailto . "'");
        sendmail("您的验证码", "您的验证码为 <b>" . $edit_code . "</b>，请妥善保管不要告诉他人。", urldecode($mailto));
        $code = "success";
        $code_info = "发送成功";
    } else {
        $code = "error";
        $code_info = "邮箱尚未注册";
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "emailFound":
    $M_email = $_REQUEST["M_email"];
    $M_code = $_REQUEST["M_code"];
    $sql = "Select * from ".TABLE."member where M_del=0 and M_email='" . urldecode($M_email) . "' and M_pwdcode='" . $M_code . "'";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $M_login = $row["M_login"];
        $code = "success";
        $code_info = "新密码已发送到邮箱";
        $newpwd = rand(10000, 99999);
        mysqli_query($conn, "update ".TABLE."member set M_pwd='" . $newpwd . "' where M_email='" . $M_email . "'");
        sendmail("您的验证码", "您的用户名为：" . $M_login . "，新密码为 <b>" . $newpwd . "</b>，请妥善保管不要告诉他人。", urldecode($M_email));
    } else {
        $code = "error";
        $code_info = "验证码错误";
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "wuliu":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $O_id = $_REQUEST["O_id"];
    $sql = "select * from ".TABLE."orders where O_id=" . $O_id . "";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    $O_wl = $row["O_wl"];
    $O_wlid = $row["O_wlid"];
    $wl_info = GetBody("http://www.kuaidi100.com/query?type=" . splitx($O_wl, "|", 1) . "&postid=" . $O_wlid, "");
    $wl_info = simplexml_load_string($wl_info);
    for ($i = 0; $i < count($wl_info->data) - 1; $i++) {
        $wuliu = $wuliu . "{\"time\":\"" . $wl_info->data[$i]->time . "\",\"location\":\"" . $wl_info->data[$i]->location . "\",\"context\":\"" . $wl_info->data[$i]->context . "\"},";
    }
    $wuliu = substr($wuliu, 0, strlen($wuliu) - 1);
    $api = "{\"O_wl\":\"" . $O_wl . "\",\"O_wlid\":\"" . $O_wlid . "\",\"wuliu\":[" . $wuliu . "]}";
    break;

case "OK":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $O_id = $_REQUEST["O_id"];
    mysqli_query($conn, "update ".TABLE."orders set O_state=3 where O_id=" . $O_id);
    $api = "{\"code\":\"success\"}";
    break;

case "TK":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $O_id = $_REQUEST["O_id"];
    mysqli_query($conn, "update ".TABLE."orders set O_state=4 where O_id=" . $O_id);
    $api = "{\"code\":\"success\"}";
    break;

case "remove":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $O_id = $_REQUEST["O_id"];
    mysqli_query($conn, "delete from ".TABLE."orders where O_id=" . $O_id);
    $api = "{\"code\":\"success\"}";
    break;
case "zz":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $O_id = $_REQUEST["O_id"];
    mysqli_query($conn, "update ".TABLE."orders set O_state=7 where O_id=" . $O_id);
    $api = "{\"code\":\"success\"}";
    break;

case "buy":
    if (!check($M_id, $M_pwd)) {
        die();
    }
    $P_id = $_REQUEST["P_id"];
    $no = $_REQUEST["no"];
    if ($M_id == "" || is_null($M_id)) {
        $code = "error";
        $code_info = "尚未登录会员账号";
    } else {
        $sql = "select * from ".TABLE."product where P_id=" . $P_id;
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if (mysqli_num_rows($result) > 0) {
            $P_title = $row["P_title"];
            $P_price = $row["P_price"];
            $P_shuxing = $row["P_shuxing"];
        }
        $sp = 0;
        foreach ($_POST as $x => $value) {
            if (splitx($x, "_", 0) == "scvvvvv") {
                if ($_POST[$x] == "") {
                    $ss = 0;
                } else {
                    $ss = $_POST[$x];
                }
                $sc = $sc . splitx(splitx(splitx($P_shuxing, "@", splitx($x, "_", 1)) , "_", 1) , "|", $ss) . "|";
                $sp = $sp + splitx(splitx(splitx($P_shuxing, "@", splitx($x, "_", 1)) , "_", 2) , "|", $ss);
            }
        }
        $sc = substr($sc, 0, strlen($sc) - 1);
        if ($sc == "") {
            $sc = "标配";
        }

        $price=$P_price+$sp;
        $M_lv=getrx("select * from ".TABLE."member where M_id=".$M_id,"M_lv");
        $L_discount=getrx("select * from ".TABLE."lv where L_id=".$M_lv,"L_discount");

        mysqli_query($conn, "Insert into ".TABLE."orders(O_member,O_price,O_num,O_shuxing,O_state,O_pid,O_time,O_no) values(" . $M_id . "," . round($price*$L_discount*0.01,2) . "," . $no . ",'" . $sc . "',0," . $P_id . ",'" . date('Y-m-d H:i:s') . "','".date("YmdHis").gen_key(5)."')");
        $code = "success";
        $code_info = "成功";
    }
    $api = "{\"code\":\"" . $code . "\",\"code_info\":\"" . $code_info . "\"}";
    break;

case "prepay";
$O_ids = $_REQUEST["O_id"];
$openid = $_REQUEST["openid"];
$O_id = explode(",", $O_ids);
for ($i = 0; $i < count($O_id); $i++) {
    $sql = "select * from ".TABLE."orders,".TABLE."product,".TABLE."member,".TABLE."lv where M_del=0 and P_del=0 and O_member=M_id and M_lv=L_id and O_pid=P_id and O_id=" . $O_id[$i];
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $P_title = $row["P_title"];
        $P_path = $row["P_path"];
        $O_num = $row["O_num"];
        $O_price = $row["O_price"];
        $O_shuxings = $row["O_shuxing"];
        $L_discount = $row["L_discount"];
    }
    $O_shuxing = explode("|", $O_shuxings);
    for ($j = 0; $j < count($O_shuxing); $j++) {
        $shuxing = $shuxing . lang($O_shuxing[$j]) . " ";
    }
    $O_shuxing = $shuxing;
    $O_all = $O_price * $O_num * $L_discount * 0.01;
    $money = $money + $O_price * $O_num * $L_discount * 0.01;
    if ($i > 0) {
    } else {
        if (count($O_id) > 0) {
            $P_title1 = lang($P_title) . "等" . (count($O_id) + 1) . "件商品";
        } else {
            $P_title1 = lang($P_title);
        }
    }
    $shuxing = "";
}
$total_money = $money * 100;
$nonce_str = gen_key(20);
$str = "appid=" . $C_wxappID . "&attach=" . $O_ids . "&body=" . $P_title1 . "&mch_id=" . $C_wx_mchid . "&nonce_str=" . $nonce_str . "&notify_url=http://" . $C_domain . $C_dir . "api/notify.php&openid=" . $openid . "&out_trade_no=" . $nonce_str . "&spbill_create_ip=127.0.0.1&total_fee=" . $total_money . "&trade_type=JSAPI&key=" . $C_wx_key;


$sign = md5($str);
$formData = "<xml>";
$formData = $formData . "<appid>" . $C_wxappID . "</appid>";
$formData = $formData . "<attach>" . $O_ids . "</attach>";
$formData = $formData . "<body>" . $P_title1 . "</body>";
$formData = $formData . "<mch_id>" . $C_wx_mchid . "</mch_id>";
$formData = $formData . "<nonce_str>" . $nonce_str . "</nonce_str>";
$formData = $formData . "<notify_url>http://" . $C_domain . $C_dir . "api/notify.php</notify_url>";
$formData = $formData . "<openid>" . $openid . "</openid>";
$formData = $formData . "<out_trade_no>" . $nonce_str . "</out_trade_no>";
$formData = $formData . "<spbill_create_ip>127.0.0.1</spbill_create_ip>";
$formData = $formData . "<total_fee>" . $total_money . "</total_fee>";
$formData = $formData . "<trade_type>JSAPI</trade_type>";
$formData = $formData . "<sign>" . strtoupper($sign) . "</sign>";
$formData = $formData . "</xml>";

$info = GetBody("https://api.mch.weixin.qq.com/pay/unifiedorder", $formData);

$info = simplexml_load_string($info);
$prepay_id = $info->prepay_id[0];
$str2 = "appId=" . $C_wxappID . "&nonceStr=BiIUif6MUIWM0S7YaXlH&package=prepay_id=" . $prepay_id . "&signType=MD5&timeStamp=1490840662&key=" . $C_wx_key;
$pay_sign = md5($str2);
$api = "{\"prepay_id\":\"" . $prepay_id . "\",\"pay_sign\":\"" . strtoupper($pay_sign) . "\"}";
break;


case "notice_list":

$sql="select * from ".TABLE."news where N_type=4 and N_del=0 limit 5";
    $result = mysqli_query($conn, $sql);
    $arr = array();  
    while($row = mysqli_fetch_array($result)) {
    $row["N_title"]=lang($row["N_title"]);
    $count=count($row);
      for($i=0;$i<$count;$i++){ 
        unset($row[$i]);
      }   
    array_push($arr,$row);
} 

echo "{\"newslist\":".json_encode($arr)."}";

break;

case "news_list2":

$sql="select * from ".TABLE."news where N_type=0 and N_del=0 limit 5";
    $result = mysqli_query($conn, $sql);
    $arr = array();  
    while($row = mysqli_fetch_array($result)) {
    $row["N_title"]=lang($row["N_title"]);
    $count=count($row);
      for($i=0;$i<$count;$i++){ 
        unset($row[$i]);
      }   
    array_push($arr,$row);
} 

echo "{\"newslist\":".json_encode($arr)."}";

break;

case "huodong_list":

$sql="select * from ".TABLE."news,".TABLE."nsort where N_sort=S_id and S_sub=108 and N_del=0 limit 5";
    $result = mysqli_query($conn, $sql);
    $arr = array();  
    while($row = mysqli_fetch_array($result)) {
    $row["N_title"]=lang($row["N_title"]);
    $row["N_date"]=splitx($row["N_job"],"|",0);
    $count=count($row);
      for($i=0;$i<$count;$i++){ 
        unset($row[$i]);
      }   
    array_push($arr,$row);
} 

echo "{\"newslist\":".json_encode($arr)."}";

break;

case "news_list";
$orderby = "N_top DESC,N_order ASC,N_id DESC";
if (strpos($num, "|") !== false) {
    $num = $C_npage;
} else {
    $num = splitx($num, "|", 0);
}
$S_page = $page;
if ($S_page == "") {
    $S_page = 1;
}
if ($num == "0") {
    $num_info = "";
} else {
    $num_info = "limit " . $num;
}
if (strpos($S_id, "tag") === false && strpos($S_id, "date") === false && strpos($S_id, "author") === false && strpos($S_id, "type") === false) {
    $S_id = splitx($S_id, "|", 0);
    if (!is_numeric($S_id)) {
        $sql = "select * from ".TABLE."nsort where S_del=0 and S_sub=0 order by S_order,S_id desc";
        $result = mysqli_query($conn, $sql);
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $S_sublist = $S_sublist . $row["S_id"] . ",";
                $sql2 = "select * from ".TABLE."nsort where S_del=0 and S_sub=" . $row["S_id"] . " order by S_order,S_id desc";
                $result2 = mysqli_query($conn, $sql2);
                if (mysqli_num_rows($result2) > 0) {
                    while ($row2 = mysqli_fetch_assoc($result2)) {
                        $S_list = $S_list . $row2["S_id"] . ",";
                    }
                }
            }
        }
        $S_list = $S_list . "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
        $S_sublist = $S_sublist . "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0";
        switch ($S_id) {
            case "a":
                $top = 0;
                $sub_info = 0;
                break;

            case "b":
                $top = 1;
                $sub_info = 0;
                break;

            case "c":
                $top = 2;
                $sub_info = 0;
                break;

            case "d":
                $top = 3;
                $sub_info = 0;
                break;

            case "e":
                $top = 4;
                $sub_info = 0;
                break;

            case "f":
                $top = 5;
                $sub_info = 0;
                break;

            case "g":
                $top = 6;
                $sub_info = 0;
                break;

            case "h":
                $top = 7;
                $sub_info = 0;
                break;

            case "i":
                $top = 8;
                $sub_info = 0;
                break;

            case "j":
                $top = 9;
                $sub_info = 0;
                break;

            case "k":
                $top = 10;
                $sub_info = 0;
                break;

            case "A":
                $top = 0;
                $sub_info = 1;
                break;

            case "B":
                $top = 1;
                $sub_info = 1;
                break;

            case "C":
                $top = 2;
                $sub_info = 1;
                break;

            case "D":
                $top = 3;
                $sub_info = 1;
                break;

            case "E":
                $top = 4;
                $sub_info = 1;
                break;

            case "F":
                $top = 5;
                $sub_info = 1;
                break;

            case "G":
                $top = 6;
                $sub_info = 1;
                break;

            case "H":
                $top = 7;
                $sub_info = 1;
                break;

            case "I":
                $top = 8;
                $sub_info = 1;
                break;

            case "J":
                $top = 9;
                $sub_info = 1;
                break;

            case "K":
                $top = 10;
                $sub_info = 1;
        }
        if ($sub_info == 0) {
            $S_id = splitx($S_list, ",", $top);
        } else {
            $S_id = splitx($S_sublist, ",", $top);
        }
    }
    $sql = "select S_id from ".TABLE."nsort where S_del=0 order by S_id asc limit 1";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        $S_aid = $row["S_id"];
    }
    if ($S_id == 0) {
        $S_id_info = "";
    } else {
        $sql = "select * from ".TABLE."nsort where S_del=0 and S_id=" . $S_id;
        $result = mysqli_query($conn, $sql);
        $row = mysqli_fetch_assoc($result);
        if (mysqli_num_rows($result) > 0) {
            $S_sub = $row["S_sub"];
        }
        if ($S_sub != 0) {
            $S_id_info = "and S_id=" . $S_id;
        } else {
            $S_id_info = "and S_sub=" . $S_id;
        }
    }
} else {
    switch (splitx($S_id, ":", 0)) {
        case "tag":
            $S_id_info = "and N_tag like '%," . splitx($S_id, ":", 1) . ",%'";
            break;

        case "author":
            $S_id_info = "and N_author like '" . splitx($S_id, ":", 1) . "'";
            break;

        case "date":
            $S_id_info = "and year(N_date)=" . date("Y", strtotime(splitx($S_id, ":", 1))) . " and month(N_date)=" . date("m", strtotime(splitx($S_id, ":", 1))) . " and day(N_date)=" . date("d", strtotime(splitx($S_id, ":", 1)));
            break;

        case "type":
            switch (splitx($S_id, ":", 1)) {
                case "news":
                    $N_tp = 0;
                    break;

                case "job":
                    $N_tp = 1;
                    break;

                case "download":
                    $N_tp = 2;
                    break;

                case "video":
                    $N_tp = 3;
                    break;

                case "notice":
                    $N_tp = 4;
                default:
                    $N_tp = 0;
            }
            $S_id_info = "and N_type=" . $N_tp;
    }
}

$x = 0;

if ($S_page==1){
    $sql = "select * from ".TABLE."news,".TABLE."nsort where N_del=0 and S_del=0 and N_sort=S_id " . $S_id_info . " and N_sh=0 and S_show=1 order by " . $orderby ." ". $num_info;
}else{
    $sql = "select * from ".TABLE."news,".TABLE."nsort where N_del=0 and S_del=0 and N_sort=S_id " . $S_id_info . " and N_sh=0 and S_show=1 order by " . $orderby . " limit " . $num * ($S_page - 1) . "," . $num;
}

$sql = trim($sql, "\xEF\xBB\xBF");
$result = mysqli_query($conn, $sql);
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        if ($S_id !== "0") {
            if ($S_sub == 0) {
                $S_pic = getrx("select * from ".TABLE."nsort where S_id=" . $row["S_sub"],"S_pic");
                $S_title = lang(getrx("select * from ".TABLE."nsort where S_id=" . $row["S_sub"],"S_title"));
                $S_id = getrx("select * from ".TABLE."nsort where S_id=" . $row["S_sub"],"S_id");
                $S_entitle = lang(getrx("select * from ".TABLE."nsort where S_id=" . $row["S_sub"],"S_entitle"));
                $S_description = lang(getrx("select * from ".TABLE."nsort where S_id=" . $row["S_sub"],"S_description"));
            } else {
                $S_pic = $row["S_pic"];
                $S_title = lang($row["S_title"]);
                $S_id = $row["S_id"];
                $S_entitle = lang($row["S_entitle"]);
                $S_description = lang($row["S_description"]);
            }
        } else {
            $S_title = lang($C_nsorttitle);
            $S_id = $row["S_id"];
            $S_entitle = lang($C_nsortentitle);
            $S_description = "";
        }
        $N_title = lang($row["N_title"]);
        $N_pic = "http://" . $C_domain . $C_dir . $row["N_pic"];
        $N_author = $row["N_author"];
        $N_short = lang($row["N_short"]);
        $N_content = lang($row["N_content"]);
        $N_id = $row["N_id"];
        $N_time = $row["N_date"];
        $N_date = date("Y", strtotime($row["N_date"])) . "-" . date("m", strtotime($row["N_date"])) . "-" . date("d", strtotime($row["N_date"]));
        $N_year = date("Y", strtotime($row["N_date"]));
        $N_month = date("m", strtotime($row["N_date"]));
        $N_day = date("d", strtotime($row["N_date"]));
        $N_view = $row["N_view"];
        $nsortlist = "{\"S_id\":\"" . $S_id . "\",\"S_title\":\"" . $S_title . "\",\"S_entitle\":\"" . $S_entitle . "\",\"S_pic\":\"http://" . $C_domain . $C_dir . $S_pic . "\",\"S_description\":\"" . $S_description . "\"}";
        $newslist = $newslist . "{\"N_id\":\"" . $N_id . "\",\"N_title\":\"" . gljson($N_title) . "\",\"S_title\":\"" . $S_title . "\",\"N_short\":\"" . gljson($N_short) . "\",\"N_date\":\"" . $N_date . "\",\"N_pic\":\"" . $N_pic . "\",\"N_author\":\"" . $N_author . "\",\"N_year\":\"" . $N_year . "\",\"N_month\":\"" . $N_month . "\",\"N_day\":\"" . $N_day . "\",\"N_view\":\"" . $N_view . "\"},";
    }
    $newslist = substr($newslist, 0, strlen($newslist) - 1);
}
if ($nsortlist == "") {
    $nsortlist = "[]";
}
$api = "{\"newslist\":[" . $newslist . "],\"nsortlist\":" . $nsortlist . ",\"sql\":\"" . $sql . "\"}";
} //switch
if ($callback == "") {
    echo $api;
} else {
    echo $callback . "(" . $api . ")";
}

function check($M_id, $M_pwd) {
    global $conn;
    $sql = "select * from ".TABLE."member where M_id=" . intval($M_id);
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    if (mysqli_num_rows($result) > 0) {
        if (md5($row["M_pwd"]) == $M_pwd) {
            $check = true;
        } else {
            $check = false;
        }
    } else {
        $check = false;
    }
    return $check;
}
?>